import requests
import json
import configparser
from Log_in import sign_in
"""
Use case 4:
This code demonstrates how a shipment can be created
"""
sign_in_data = sign_in()

Token = sign_in_data[0]
url = sign_in_data[1]

headers = {
  'Authorization': 'Bearer ' + Token,
}
payload = json.dumps({})

def devices(page_url):
    response = requests.request("GET", page_url, headers=headers, data=payload)
    if response.status_code in [200]:
        for line in json.loads(response.text)["data"]:
            print("Serialnumber: " + line["id"])
        return json.loads(response.text)["links"]
    else:
        print(response.text)
        quit()


def pagination(api_url):
    page_link = devices(api_url)
    while page_link["next"] != page_link["last"]:
        page_link = devices(page_link["next"])

    if(page_link["first"] != page_link["last"]):
        devices(page_link["next"])


def main():
    shipment_name = input("Enter the shipment name: ")
    payload = json.dumps({
    "hawb": shipment_name
    })
    response = requests.request("POST", url + "/api/1.0/shipments", headers=headers, data=payload)

    if response.status_code in [201]:
            print("the shipment " + shipment_name + " has been created")
            shipment_id = (json.loads(response.text)["data"])["id"]
    else:
        print(response.text)
        quit()

    associate_device = input("Do you wish to assocaite a device to the shipment?(Y/N): ")

    if associate_device in ['y', 'Y', 'yes', 'Yes', 'YES']:
        payload = json.dumps({})
        pagination(url + "/api/1.0/devices")
        Device_id = input("Enter the Serialnumber of the device you wish to associate: ")
        payload = json.dumps({
            "device_name": Device_id
            })
        response = requests.request("POST", url + "/api/1.0/shipments/" + shipment_id + "/associations", headers=headers, data=payload)
        if response.status_code in [201]:
                print("Device associated to shipment successfully")
        else:
            print(response.text)
            quit()
    else:
        quit()

if __name__ == "__main__":
    main()
